/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.trollcave;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.SphereReplaceConfig;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.gen.placement.DepthAverageConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import twilightforest.TFFeature;
import twilightforest.structures.trollcave.TrollCaveMainComponent;
import twilightforest.structures.trollcave.TrollCavePieces;
import twilightforest.world.feature.TFBiomeFeatures;
import twilightforest.worldgen.BlockConstants;

public class TrollCaveGardenComponent
extends TrollCaveMainComponent {
    private final ConfiguredFeature<?, ?> myceliumBlobGen = ((Feature)TFBiomeFeatures.MYCELIUM_BLOB.get()).func_225566_b_((IFeatureConfig)new SphereReplaceConfig(BlockConstants.MYCELIUM, FeatureSpread.func_242253_a((int)5, (int)2), 0, (List)ImmutableList.of((Object)BlockConstants.STONE, (Object)BlockConstants.DEADROCK))).func_227228_a_(Placement.field_242910_o.func_227446_a_((IPlacementConfig)new DepthAverageConfig(15, 10)));
    private final ConfiguredFeature<?, ?> dirtGen = ((Feature)TFBiomeFeatures.MYCELIUM_BLOB.get()).func_225566_b_((IFeatureConfig)new SphereReplaceConfig(BlockConstants.DIRT, FeatureSpread.func_242253_a((int)5, (int)2), 0, (List)ImmutableList.of((Object)BlockConstants.STONE, (Object)BlockConstants.DEADROCK))).func_227228_a_(Placement.field_242910_o.func_227446_a_((IPlacementConfig)new DepthAverageConfig(15, 10)));
    private final ConfiguredFeature<?, ?> smallUberousGen = ((Feature)TFBiomeFeatures.MYCELIUM_BLOB.get()).func_225566_b_((IFeatureConfig)new SphereReplaceConfig(BlockConstants.UBEROUS_SOIL, FeatureSpread.func_242253_a((int)4, (int)3), 0, (List)ImmutableList.of((Object)BlockConstants.PODZOL, (Object)BlockConstants.COARSE_DIRT, (Object)BlockConstants.DIRT))).func_227228_a_(Placement.field_242910_o.func_227446_a_((IPlacementConfig)new DepthAverageConfig(60, 10)));
    private final ConfiguredFeature<?, ?> bigRedMushroomGen = Features.field_243861_bG.func_227228_a_(Placement.field_242910_o.func_227446_a_((IPlacementConfig)new DepthAverageConfig(15, 10)));
    private final ConfiguredFeature<?, ?> bigBrownMushroomGen = Features.field_243860_bF.func_227228_a_(Placement.field_242910_o.func_227446_a_((IPlacementConfig)new DepthAverageConfig(15, 10)));
    private final ConfiguredFeature<?, ?> bigMushgloomGen = ((Feature)TFBiomeFeatures.BIG_MUSHGLOOM.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_242910_o.func_227446_a_((IPlacementConfig)new DepthAverageConfig(15, 10)));

    public TrollCaveGardenComponent(TemplateManager manager, CompoundNBT nbt) {
        super(TrollCavePieces.TFTCGard, nbt);
    }

    public TrollCaveGardenComponent(TFFeature feature, int index, int x, int y, int z, int caveSize, int caveHeight, Direction direction) {
        super(TrollCavePieces.TFTCGard, feature, index);
        this.size = caveSize;
        this.height = caveHeight;
        this.func_186164_a(direction);
        this.field_74887_e = feature.getComponentToAddBoundingBox(x, y, z, 0, 0, 0, this.size - 1, this.height - 1, this.size - 1, direction);
    }

    @Override
    public void func_74861_a(StructurePiece parent, List<StructurePiece> list, Random rand) {
    }

    @Override
    public boolean func_230383_a_(ISeedReader world, StructureManager manager, ChunkGenerator generator, Random rand, MutableBoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        BlockPos dest;
        int i;
        this.hollowCaveMiddle(world, sbb, rand, 0, 0, 0, this.size - 1, this.height - 1, this.size - 1);
        Random decoRNG = new Random(world.func_72905_C() + (long)(this.field_74887_e.field_78897_a * 321534781) ^ (long)(this.field_74887_e.field_78896_c * 756839));
        this.makeTreasureCrate(world, sbb);
        for (i = 0; i < 24; ++i) {
            dest = this.getCenterBiasedCaveCoords(decoRNG);
            this.generate(world, generator, this.dirtGen, decoRNG, dest.func_177958_n() * 4, 1, dest.func_177952_p() * 4, sbb);
        }
        for (i = 0; i < 16; ++i) {
            dest = this.getCenterBiasedCaveCoords(decoRNG);
            this.generate(world, generator, this.myceliumBlobGen, decoRNG, dest.func_177958_n() * 4, 1, dest.func_177952_p() * 4, sbb);
        }
        for (i = 0; i < 16; ++i) {
            dest = this.getCoordsInCave(decoRNG);
            this.generate(world, generator, this.smallUberousGen, decoRNG, dest.func_177958_n() * 4, 1, dest.func_177952_p() * 4, sbb);
            this.generateAtSurface(world, generator, this.smallUberousGen, decoRNG, dest.func_177958_n(), 60, dest.func_177952_p(), sbb);
        }
        for (i = 0; i < 32; ++i) {
            dest = this.getCenterBiasedCaveCoords(decoRNG);
            this.generate(world, generator, this.bigMushgloomGen, decoRNG, dest.func_177958_n() * 4, 1, dest.func_177952_p() * 4, sbb);
        }
        for (i = 0; i < 64; ++i) {
            dest = this.getCenterBiasedCaveCoords(decoRNG);
            this.generate(world, generator, rand.nextBoolean() ? this.bigBrownMushroomGen : this.bigRedMushroomGen, decoRNG, dest.func_177958_n() * 4, 1, dest.func_177952_p() * 4, sbb);
        }
        for (i = 0; i < 128; ++i) {
            dest = this.getCoordsInCave(decoRNG);
            this.generateBlockStalactite(world, generator, decoRNG, Blocks.field_150348_b, 0.7f, true, dest.func_177958_n(), 3, dest.func_177952_p(), sbb);
        }
        return true;
    }

    protected void generate(ISeedReader world, ChunkGenerator generator, ConfiguredFeature<?, ?> feature, Random rand, int x, int y, int z, MutableBoundingBox sbb) {
        int dz;
        int dy;
        int dx = this.func_74865_a(x, z);
        BlockPos pos = new BlockPos(dx, dy = this.func_74862_a(y), dz = this.func_74873_b(x, z));
        if (sbb.func_175898_b((Vector3i)pos)) {
            feature.func_242765_a(world, generator, rand, pos);
        }
    }
}

